/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.store;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.store.EStoreType;
import ru.uss.vstore.model.store.TaxpayerStore;
import ru.uss.vstore.validation.store.TaxpayerStoreMobile;

public class TaxpayerStoreMobileValidator
extends AbstractClassLevelValidator<TaxpayerStoreMobile, TaxpayerStore> {
    public void initialize(TaxpayerStoreMobile taxpayerStoreMobile) {
        this.annotation = taxpayerStoreMobile;
    }

    public boolean isValid(TaxpayerStore store, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (store == null) {
            return true;
        }
        boolean result = true;
        if (EStoreType.MOBILE_STORE.equals((Object)store.getStoreTypeCode())) {
            if (BooleanUtils.isTrue((Boolean)store.getDefault())) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndDefault.incompatible}").addPropertyNode("isDefault").addConstraintViolation();
                result = false;
            }
            if (BooleanUtils.isTrue((Boolean)store.getPostingGoods())) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndPostingGoods.incompatible}").addPropertyNode("isPostingGoods").addConstraintViolation();
                result = false;
            }
            if (BooleanUtils.isTrue((Boolean)store.getJointStore())) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndJointStore.incompatible}").addPropertyNode("isJointStore").addConstraintViolation();
                result = false;
            }
            if (BooleanUtils.isTrue((Boolean)store.getCooperativeStore())) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndCooperativeStore.incompatible}").addPropertyNode("isCooperativeStore").addConstraintViolation();
                result = false;
            }
            if (BooleanUtils.isTrue((Boolean)store.getInherited())) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndInherited.incompatible}").addPropertyNode("isInherited").addConstraintViolation();
                result = false;
            }
            if (store.getOilOvdId() != null) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndOilOvd.incompatible}").addPropertyNode("oilOvdId").addConstraintViolation();
                result = false;
            }
            if (store.getTobaccoOvdId() != null) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndTobaccoOvd.incompatible}").addPropertyNode("tobaccoOvdId").addConstraintViolation();
                result = false;
            }
            if (store.getAlcoholLicenseId() != null) {
                context.buildConstraintViolationWithTemplate("{taxpayerStore.MobileStoreAndAlcoholLicense.incompatible}").addPropertyNode("alcoholLicenseId").addConstraintViolation();
                result = false;
            }
        }
        return result;
    }
}

