/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uform;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormPhysicalLabelUniquenessV1;

public class UFormPhysicalLabelUniquenessValidatorV1
extends AbstractClassLevelValidator<UFormPhysicalLabelUniquenessV1, UFormV1> {
    public UFormPhysicalLabelUniquenessValidatorV1() {
        super("products[%d].physicalLabel");
    }

    public void initialize(UFormPhysicalLabelUniquenessV1 uFormPhysicalLabelUniquenessV1) {
    }

    public boolean isValid(UFormV1 uFormV1, ConstraintValidatorContext constraintValidatorContext) {
        if (uFormV1 == null || CollectionUtils.isEmpty(uFormV1.getProducts())) {
            return true;
        }
        Map<String, List<UFormProductV1>> productByPhysicalLabel = uFormV1.getProducts().stream().filter(p -> !StringUtils.isEmpty((Object)p.getPhysicalLabel())).collect(Collectors.groupingBy(UFormProductV1::getPhysicalLabel));
        List<Integer> productNumbers = productByPhysicalLabel.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).flatMap(e -> ((List)e.getValue()).stream()).map(p -> uFormV1.getProducts().indexOf(p)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(productNumbers)) {
            productNumbers.forEach(index -> this.setupContextWithValidationError(constraintValidatorContext, String.format(this.fieldName, index), "{uFormProduct.physicalLabel.notUnique}"));
            return false;
        }
        return true;
    }
}

