/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uformproduct.version.v1;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;

public abstract class AbstractProductOriginCertificateNumberValidator<A extends Annotation>
extends AbstractClassLevelValidator<A, UFormProductV1> {
    private static final Pattern PATTERN_FOR_11_LENGTH = Pattern.compile("^KZ[0-9]{9}$");
    private static final Pattern PATTERN_FOR_13_LENGTH = Pattern.compile("^KZ.{2}[0-9]{9}$");
    private static final Pattern PATTERN_FOR_18_LENGTH = Pattern.compile("^[0-9]{12}[NI][0-9]{5}$");
    private static final Pattern PATTERN_FOR_20_LENGTH = Pattern.compile("^[0-9]{5}/[0-9]{6}/[0-9]{7}$");
    private static final Pattern PATTERN_FOR_20_ZVT_LENGTH = Pattern.compile("^[0-9]{5}/[0-9]{6}/B[0-9]{6}$");
    private static final Pattern PATTERN_FOR_42_LENGTH = RegistrationNumberUtils.SNT_PATTERN;

    public AbstractProductOriginCertificateNumberValidator() {
        super("manufactureOrImportDocNumber");
    }

    protected boolean validateForLength_18_20(String manufactureOrImportDocNumber, ConstraintValidatorContext context) {
        if (manufactureOrImportDocNumber == null) {
            return true;
        }
        if (manufactureOrImportDocNumber.length() == 18) {
            if (!PATTERN_FOR_18_LENGTH.matcher(manufactureOrImportDocNumber).matches() || !DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(4, 12), "ddMMyyyy")) {
                return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.invalidFormat.18l}");
            }
            return true;
        }
        if (manufactureOrImportDocNumber.length() == 20) {
            if (!PATTERN_FOR_20_LENGTH.matcher(manufactureOrImportDocNumber).matches() && !PATTERN_FOR_20_ZVT_LENGTH.matcher(manufactureOrImportDocNumber).matches() || !DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(6, 12), "ddMMyy")) {
                return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.invalidFormat.20l}");
            }
            return true;
        }
        if (manufactureOrImportDocNumber.length() == 42) {
            if (!PATTERN_FOR_42_LENGTH.matcher(manufactureOrImportDocNumber).matches() || !DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(25, 33), "yyyyMMdd")) {
                return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.invalidFormat.20l}");
            }
            return true;
        }
        return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.18_20.invalidLength}");
    }

    protected boolean validateForLength_11_13(String manufactureOrImportDocNumber, ConstraintValidatorContext context) {
        if (manufactureOrImportDocNumber == null) {
            return true;
        }
        if (manufactureOrImportDocNumber.length() == 11) {
            if (!PATTERN_FOR_11_LENGTH.matcher(manufactureOrImportDocNumber).matches()) {
                return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.invalidFormat.11l}");
            }
            return true;
        }
        if (manufactureOrImportDocNumber.length() == 13) {
            if (!PATTERN_FOR_13_LENGTH.matcher(manufactureOrImportDocNumber).matches()) {
                return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.invalidFormat.13l}");
            }
            return true;
        }
        return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.11_13.invalidLength}");
    }
}

